/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2504;
import net.minecraft.class_2506;
import net.minecraft.class_2520;
import net.minecraft.class_265;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.Mesh2D;

public class BreakableMirror
extends Mirror {
    public static final class_1299<BreakableMirror> ENTITY_TYPE = BreakableMirror.createPortalEntityType(BreakableMirror::new);
    @Nullable
    public IntBox wallArea;
    @Nullable
    public BlockPortalShape blockPortalShape;
    public boolean unbreakable = false;

    public BreakableMirror(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.wallArea = tag.method_10545("boxXL") ? new IntBox(new class_2338(tag.method_10550("boxXL"), tag.method_10550("boxYL"), tag.method_10550("boxZL")), new class_2338(tag.method_10550("boxXH"), tag.method_10550("boxYH"), tag.method_10550("boxZH"))) : null;
        this.blockPortalShape = tag.method_10545("blockPortalShape") ? BlockPortalShape.fromTag(tag.method_10562("blockPortalShape")) : null;
        if (tag.method_10545("unbreakable")) {
            this.unbreakable = tag.method_10577("unbreakable");
        }
    }

    @Override
    protected void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.wallArea != null) {
            tag.method_10569("boxXL", this.wallArea.l.method_10263());
            tag.method_10569("boxYL", this.wallArea.l.method_10264());
            tag.method_10569("boxZL", this.wallArea.l.method_10260());
            tag.method_10569("boxXH", this.wallArea.h.method_10263());
            tag.method_10569("boxYH", this.wallArea.h.method_10264());
            tag.method_10569("boxZH", this.wallArea.h.method_10260());
        }
        if (this.blockPortalShape != null) {
            tag.method_10566("blockPortalShape", (class_2520)this.blockPortalShape.toTag());
        }
        tag.method_10556("unbreakable", this.unbreakable);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && !this.unbreakable && this.method_37908().method_8510() % 10L == (long)(this.method_5628() % 10)) {
            this.checkWallIntegrity();
        }
    }

    @Override
    public boolean isPortalValid() {
        return super.isPortalValid() && (this.wallArea != null || this.blockPortalShape != null);
    }

    private void checkWallIntegrity() {
        boolean wallValid = this.wallArea != null ? this.wallArea.fastStream().allMatch(blockPos -> BreakableMirror.isGlass(this.method_37908(), blockPos)) : (this.blockPortalShape != null ? this.blockPortalShape.area.stream().allMatch(blockPos -> BreakableMirror.isGlass(this.method_37908(), blockPos)) : false);
        if (!wallValid) {
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public static boolean isGlass(class_1937 world, class_2338 blockPos) {
        class_2248 block = world.method_8320(blockPos).method_26204();
        return block == class_2246.field_10033 || block == class_2246.field_10285 || block instanceof class_2506 || block instanceof class_2504;
    }

    private static boolean isGlassPane(class_1937 world, class_2338 blockPos) {
        class_2248 block = world.method_8320(blockPos).method_26204();
        return block == class_2246.field_10285 || block instanceof class_2504;
    }

    public static BreakableMirror createMirror(class_3218 world, class_2338 glassPos, class_2350 facing) {
        if (!BreakableMirror.isGlass((class_1937)world, glassPos)) {
            return null;
        }
        boolean isPane = BreakableMirror.isGlassPane((class_1937)world, glassPos);
        if (facing.method_10166() == class_2350.class_2351.field_11052 && isPane) {
            return null;
        }
        Predicate<class_2338> glassWallPredicate = blockPos -> BreakableMirror.isGlass((class_1937)world, blockPos) && isPane == BreakableMirror.isGlassPane((class_1937)world, blockPos) && world.method_8320(blockPos.method_10093(facing)).method_26215();
        BlockPortalShape shape = BlockPortalShape.findArea(glassPos, facing.method_10166(), glassWallPredicate, blockPos -> !glassWallPredicate.test((class_2338)blockPos));
        if (shape == null) {
            return null;
        }
        BreakableMirror breakableMirror = (BreakableMirror)ENTITY_TYPE.method_5883((class_1937)world);
        assert (breakableMirror != null);
        double distanceToCenter = isPane ? 0.0625 : 0.5;
        breakableMirror.blockPortalShape = shape;
        class_238 wallBox = McHelper.getWallBox((class_1937)world, shape.area.stream());
        if (wallBox == null) {
            return null;
        }
        class_243 pos = Helper.getBoxSurfaceInversed(wallBox, facing.method_10153()).method_1005();
        pos = Helper.putCoordinate(pos, facing.method_10166(), Helper.getCoordinate(shape.innerAreaBox.getCenterVec().method_1019(class_243.method_24954((class_2382)facing.method_10163()).method_1021(distanceToCenter)), facing.method_10166()));
        breakableMirror.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        breakableMirror.setDestination(pos);
        breakableMirror.setDestDim((class_5321<class_1937>)world.method_27983());
        class_3545<class_2350, class_2350> perpendicularDirections = Helper.getPerpendicularDirections(facing);
        class_2350 wDirection = (class_2350)perpendicularDirections.method_15442();
        class_2350 hDirection = (class_2350)perpendicularDirections.method_15441();
        breakableMirror.setWidth(Helper.getCoordinate(Helper.getBoxSize(wallBox), wDirection.method_10166()));
        breakableMirror.setHeight(Helper.getCoordinate(Helper.getBoxSize(wallBox), hDirection.method_10166()));
        breakableMirror.setAxisW(class_243.method_24954((class_2382)wDirection.method_10163()));
        breakableMirror.setAxisH(class_243.method_24954((class_2382)hDirection.method_10163()));
        BreakableMirror.initializeMirrorGeometryShape(breakableMirror, facing, shape);
        BreakableMirror.breakIntersectedMirror(breakableMirror);
        world.method_8649((class_1297)breakableMirror);
        return breakableMirror;
    }

    private static void initializeMirrorGeometryShape(BreakableMirror breakableMirror, class_2350 facing, BlockPortalShape shape) {
        if (shape.isRectangle()) {
            breakableMirror.setPortalShapeToDefault();
            return;
        }
        class_243 center = breakableMirror.getOriginPos();
        class_1937 world = breakableMirror.method_37908();
        class_243 axisW = breakableMirror.getAxisW();
        class_243 axisH = breakableMirror.getAxisH();
        Mesh2D mesh2D = new Mesh2D();
        for (class_2338 blockPos : shape.area) {
            class_265 collisionShape = world.method_8320(blockPos).method_26220((class_1922)world, blockPos);
            if (collisionShape.method_1110()) continue;
            class_238 bounds = collisionShape.method_1107().method_997(class_243.method_24954((class_2382)blockPos));
            class_243 p1 = new class_243(bounds.field_1323, bounds.field_1322, bounds.field_1321);
            class_243 p2 = new class_243(bounds.field_1320, bounds.field_1325, bounds.field_1324);
            double p1LocalX = p1.method_1020(center).method_1026(axisW);
            double p1LocalY = p1.method_1020(center).method_1026(axisH);
            double p2LocalX = p2.method_1020(center).method_1026(axisW);
            double p2LocalY = p2.method_1020(center).method_1026(axisH);
            mesh2D.addQuad(p1LocalX, p1LocalY, p2LocalX, p2LocalY);
        }
        breakableMirror.setPortalShape(new SpecialFlatPortalShape(mesh2D));
    }

    public IntBox getAreaBox() {
        if (this.wallArea != null) {
            return this.wallArea;
        }
        if (this.blockPortalShape != null) {
            return this.blockPortalShape.innerAreaBox;
        }
        throw new RuntimeException();
    }

    private static void breakIntersectedMirror(BreakableMirror newMirror) {
        McHelper.getEntitiesNearby(newMirror, BreakableMirror.class, IPGlobal.maxNormalPortalRadius).stream().filter(mirror1 -> mirror1.getNormal().method_1026(newMirror.getNormal()) > 0.5).filter(mirror1 -> IntBox.getIntersect(mirror1.getAreaBox(), newMirror.getAreaBox()) != null).filter(mirror -> mirror != newMirror).forEach(e -> e.method_5650(class_1297.class_5529.field_26998));
    }
}

